<?php
#	SonicCampGuard
#
#	Copyright (c) 2024 Bundeswehr
#	Diese Anwendung wurde von Cedric Prietz entwickelt.
#	E-Mail: CedricPrietz@bundeswehr.org
#	App: 90-8303-54618
#
#	Letzte Änderung: 29.01.2025

require_once $_SERVER['DOCUMENT_ROOT'] . '/function.inc.php';
pageName('Neuer Schutzbau');
requireLogin();
requireRole(['Administrator']);
showSessionAlert();
initializeDatabaseConnection();

if (isset($_POST['addShelter'])) {

    $stmt = $pdo->prepare("INSERT INTO Shelters 
            (Name, Coordinates, Phone, Radio)
            VALUES (:shelterName, :shelterCoordinates, :shelterPhone, :shelterRadio)");

    $stmt->bindParam(':shelterName', $_POST['shelterName']);
    $stmt->bindParam(':shelterCoordinates', $_POST['shelterCoordinates']);
    $stmt->bindParam(':shelterPhone', $_POST['shelterPhone']);
    $stmt->bindParam(':shelterRadio', $_POST['shelterRadio']);

    $stmt->execute();

    // AuditLog: Eintrag erstellen
    addAuditLog($_SESSION['Username'], 'Schutzbauten', 'Neuen Schutzbau "' . $_POST['shelterName'] . '" erstellt');

    // Erstellt einen Session-Alert 
    createSessionAlert("", "Schutzbau " . $_POST['shelterName'] . " erfolgreich erstellt", "success", "false", "2000");

    // Weiterleitung zur Übersicht
    header("Location: /administration/shelters");
    exit();
}

include($_SERVER['DOCUMENT_ROOT'] . '/header.inc.php');
?>

<form action="" method="post" id="addShelter" enctype="multipart/form-data">

    <div class="d-flex justify-content-between align-items-center flex-wrap grid-margin">
        <div>
            <h4 class="mb-md-0">Neu</h4>
            <span class="text-secondary">Schutzbau</span>
        </div>
        <div class="d-flex align-items-center flex-wrap text-nowrap">

            <button class="btn btn-primary btn-icon-text me-2" type="submit" name="addShelter">
                <i class="btn-icon-prepend mdi mdi-plus"></i>
                Hinzufügen
            </button>

            <a href="/administration/shelters" class="btn btn-secondary btn-icon mb-md-0">
                <i class="mdi mdi-arrow-left-top"></i>
            </a>
        </div>
    </div>

    <div class="row">

        <div class="col-lg-12 col-xl-4 grid-margin">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    Allgemein
                </div>
                <div class="card-body">

                    <div class="mb-3">
                        <label for="shelterName" class="form-label">Bezeichnung</label>
                        <input id="shelterName" name="shelterName" class="form-control" type="text" autofocus>
                    </div>
                    <div class="mb-3">
                        <label for="shelterCoordinates" class="form-label">Koordinaten</label>
                        <input id="shelterCoordinates" name="shelterCoordinates" class="form-control" type="text"
                            readonly>
                    </div>

                </div>
            </div>
        </div>

        <div class="col-lg-12 col-xl-3 grid-margin">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    Kommunikation
                </div>
                <div class="card-body">

                    <div class="mb-3">
                        <label for="shelterPhone" class="form-label">Telefon</label>
                        <input id="shelterPhone" name="shelterPhone" class="form-control" type="text">
                    </div>
                    <div class="mb-3">
                        <label for="shelterRadio" class="form-label">Funk</label>
                        <input id="shelterRadio" name="shelterRadio" class="form-control" type="text">
                    </div>

                </div>
            </div>
        </div>

        <div class="col-lg-12 col-xl-5 grid-margin">
            <div class="card">
                <div class="card-header bg-secondary text-white">
                    Position
                </div>
                <div id="map" style="height: 350px;"></div>
                <div class="card-body">Klicken Sie auf die Karte, um Koordinaten automatisch zu generieren und die
                    gewünschte Position zu markieren.</div>
            </div>
        </div>


    </div>

</form>

<?php include($_SERVER['DOCUMENT_ROOT'] . '/footer.inc.php'); ?>

<script>
    var map = L.map('map').setView([<?php echo $app_config['map_position']; ?>], 15);
    L.tileLayer('<?php echo $app_config['map_tile']; ?>', {
        attribution: ''
    }).addTo(map);

    var currentMarker = null;

    map.on('click', function (e) {
        var coords = e.latlng;
        document.getElementById('shelterCoordinates').value = coords.lat + ', ' + coords.lng;

        if (currentMarker) {
            map.removeLayer(currentMarker);
        }

        currentMarker = L.marker([coords.lat, coords.lng], { icon: shelterIcon }).addTo(map);

    });
</script>